/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.mapping.EmbeddedBeanMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.mapping.ToBeanRowTransformer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.exception.NotImplementedException;
import org.codefilarete.tool.function.Predicates;

public class ZonedDateTimeMapping<T extends Table<T>>
implements EmbeddedBeanMapping<ZonedDateTime, T> {
    private final Column<T, LocalDateTime> dateTimeColumn;
    private final Column<T, ZoneId> zoneColumn;
    private final Mapping.UpwhereColumn<T> dateTimeUpdateColumn;
    private final Mapping.UpwhereColumn<T> zoneUpdateColumn;
    private final Set<Column<T, ?>> columns;
    private final ZonedDateTimeToBeanRowTransformer zonedDateTimeRowTransformer;

    public ZonedDateTimeMapping(Column<T, LocalDateTime> dateTimeColumn, Column<T, ZoneId> zoneColumn) {
        if (!LocalDateTime.class.isAssignableFrom(dateTimeColumn.getJavaType())) {
            throw new IllegalArgumentException("Only columns with type " + Reflections.toString(LocalDateTime.class) + " are supported");
        }
        if (!ZoneId.class.isAssignableFrom(zoneColumn.getJavaType())) {
            throw new IllegalArgumentException("Only columns with type " + Reflections.toString(ZoneId.class) + " are supported");
        }
        this.dateTimeColumn = dateTimeColumn;
        this.zoneColumn = zoneColumn;
        this.dateTimeUpdateColumn = new Mapping.UpwhereColumn<T>(dateTimeColumn, true);
        this.zoneUpdateColumn = new Mapping.UpwhereColumn<T>(zoneColumn, true);
        this.columns = Collections.unmodifiableSet(Arrays.asHashSet((Object[])new Column[]{dateTimeColumn, zoneColumn}));
        this.zonedDateTimeRowTransformer = new ZonedDateTimeToBeanRowTransformer();
    }

    @Override
    public Set<Column<T, ?>> getColumns() {
        return this.columns;
    }

    @Override
    public RowTransformer<ZonedDateTime> getRowTransformer() {
        return this.zonedDateTimeRowTransformer;
    }

    @Override
    public void addPropertySetByConstructor(ValueAccessPoint<ZonedDateTime> accessor) {
    }

    @Override
    public Map<Column<T, ?>, ?> getInsertValues(ZonedDateTime zonedDateTime) {
        HashMap<Column<T, Serializable>, Serializable> result = new HashMap<Column<T, Serializable>, Serializable>();
        result.put(this.dateTimeColumn, zonedDateTime.toLocalDateTime());
        result.put(this.zoneColumn, zonedDateTime.getZone());
        return result;
    }

    @Override
    public Map<Mapping.UpwhereColumn<T>, ?> getUpdateValues(ZonedDateTime modified, ZonedDateTime unmodified, boolean allColumns) {
        HashMap<Column<T, Serializable>, Serializable> unmodifiedColumns = new HashMap<Column<T, Serializable>, Serializable>();
        HashMap toReturn = new HashMap();
        if (modified != null) {
            ZoneId modifiedZone;
            LocalDateTime modifiedDateTime;
            LocalDateTime localDateTime = modifiedDateTime = unmodified == null ? null : unmodified.toLocalDateTime();
            if (!Predicates.equalOrNull((Object)modified.toLocalDateTime(), (Object)modifiedDateTime)) {
                toReturn.put(this.dateTimeUpdateColumn, modified.toLocalDateTime());
            } else {
                unmodifiedColumns.put(this.dateTimeColumn, modifiedDateTime);
            }
            ZoneId zoneId = modifiedZone = unmodified == null ? null : unmodified.getZone();
            if (!Predicates.equalOrNull((Object)modified.getZone(), (Object)modifiedZone)) {
                toReturn.put(this.zoneUpdateColumn, modified.getZone());
            } else {
                unmodifiedColumns.put(this.zoneColumn, modifiedZone);
            }
        } else {
            toReturn.put(this.dateTimeUpdateColumn, null);
            toReturn.put(this.zoneUpdateColumn, null);
        }
        if (!toReturn.isEmpty() && allColumns) {
            for (Map.Entry unmodifiedField : unmodifiedColumns.entrySet()) {
                toReturn.put(new Mapping.UpwhereColumn((Column)unmodifiedField.getKey(), true), (Serializable)unmodifiedField.getValue());
            }
        }
        return toReturn;
    }

    @Override
    public ZonedDateTime transform(ColumnedRow row) {
        return (ZonedDateTime)this.zonedDateTimeRowTransformer.transform(row);
    }

    @Override
    public Map<ReversibleAccessor<ZonedDateTime, ?>, Column<T, ?>> getPropertyToColumn() {
        throw new NotImplementedException(Reflections.toString(ZonedDateTimeMapping.class) + " can't export a mapping between some accessors and their columns because properties of " + Reflections.toString(ZonedDateTime.class) + " can't be set");
    }

    @Override
    public Map<ReversibleAccessor<ZonedDateTime, ?>, Column<T, ?>> getReadonlyPropertyToColumn() {
        throw new NotImplementedException(Reflections.toString(ZonedDateTimeMapping.class) + " can't export a mapping between some accessors and their columns because properties of " + Reflections.toString(ZonedDateTime.class) + " can't be set");
    }

    @Override
    public Set<Column<T, ?>> getWritableColumns() {
        return this.columns;
    }

    @Override
    public Set<Column<T, ?>> getReadonlyColumns() {
        return Collections.emptySet();
    }

    @Nullable
    private ZonedDateTime buildZonedDateTime(ColumnedRow columnedRow) {
        return this.buildZonedDateTime((LocalDateTime)columnedRow.get(this.dateTimeColumn), (ZoneId)columnedRow.get(this.zoneColumn));
    }

    @Nullable
    private ZonedDateTime buildZonedDateTime(LocalDateTime dateTimeColumnName, ZoneId zoneColumnName) {
        if (dateTimeColumnName == null || zoneColumnName == null) {
            return null;
        }
        return ZonedDateTime.of(dateTimeColumnName, zoneColumnName);
    }

    class ZonedDateTimeToBeanRowTransformer
    extends ToBeanRowTransformer<ZonedDateTime> {
        public ZonedDateTimeToBeanRowTransformer() {
            super(ZonedDateTime.class, Collections.emptyMap());
        }

        @Override
        @Nullable
        public ZonedDateTime newBeanInstance(ColumnedRow row) {
            return ZonedDateTimeMapping.this.buildZonedDateTime(row);
        }
    }
}

